define([
    'underscore',
    'backbone',
    'App',
    'User',
    'marionette',

    'text!modules/notifications/notification-details-view.html',
    'text!modules/page/content/_primary-header.html',

    'modules/notifications/notification-cancellation-popup-view',
    'modules/page/popup/external-nav-popup-view',
],
function(
    _,
    Backbone,
    app,
    User,
    Marionette,
    template,
    _primaryHeaderTemplate,
    NotificationCancellationPopupView,
    ExternalNavigationWarningPopup
) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'notification-detail',
        template: _.template(template),
        templateContext: {
            primaryHeader: _.template(_primaryHeaderTemplate),
        },
        events: {
            'click #back-btn': 'routeToAppointments',
            'click #cancel-btn': 'routeToNotifications',
            'click #delete-btn': 'triggerDeleteModal',
            'click #heading-new-appointment-request-btn': 'routeToNewAppointmentRequest',
            'click #notifications-detail a': 'openExternalLink',
        },

        // eslint-disable-next-line complexity
        initialize: function() {
            var timeZone = 'Timezone Unavailable';
            var dtf;
            var options;

            if (window.Intl) {
                // eslint-disable-next-line new-cap
                dtf = Intl.DateTimeFormat();
                if (dtf && _.isFunction(dtf.resolvedOptions)) {
                    options = dtf.resolvedOptions() || {};
                    if (!_.isUndefined(options.timeZone)) {
                        timeZone = options.timeZone;
                    }
                }
            }

            this.model.set({'timeZone': timeZone});
            if (this.model.get('readFlag') === false) {
                this.updateReadStatus();
            }
        },
        routeToAppointments: function() {
            Backbone.history.navigate('appointments', {trigger: true});
        },
        routeToNotifications: function() {
            Backbone.history.navigate('notifications', {trigger: true});
        },
        routeToNewAppointmentRequest: function() {
            // when: CC_FEATURE_SET is disabled (e.g. its a defined property of disabledFeatuers)
            // then: go directly to new-va-appointment and skip CC appointment service question
            if (typeof app.disabledFeatures.get('CC_FEATURE_SET') !== 'undefined') {
                Backbone.history.navigate('new-va-appointment-request', {trigger: true});
            } else {
                Backbone.history.navigate('new-appointment-request', {trigger: true});
            }
        },
        triggerDeleteModal: function(e) {
            this.deleteMessageModalView = new NotificationCancellationPopupView({
                model: this.model,
                id: 'notification-cancellation',
                elAfterClose: '#delete-btn',
            });

            this.deleteMessageModalView.openPopup();
        },
        updateReadStatus: function() {
            var url = app.resources.get('notifications-mark-as-read').formatHref({
                'assigning-authority': User.get('idType'),
                'unique-id': User.get('id'),
                'notification-id': this.model.get('_id'),
            });

            this.model.url = url;
            this.model.set('readFlag', true);

            this.model.save({
                wait: true,
                url: url,
            });
        },
        openExternalLink: function(e) {
            var url;
            var isExternalLink;
            var navigationWarning;

            e.preventDefault();

            url = $(e.currentTarget).attr('href');
            isExternalLink = /^(https?:)?\/\//i.test(url);
            if (isExternalLink) {
                navigationWarning = new ExternalNavigationWarningPopup({
                    elAfterClose: e.currentTarget,
                    model: new Backbone.Model({href: url}),
                });
                navigationWarning.openPopup();
            } else {
                window.open(url);
            }
        },
    });
}
);
